<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Ngola - Gestão de Igrejas</title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('/platform/images/favicon.png')}}">
    <link href="{{ asset('/platform/css/style.css')}}" rel="stylesheet">

</head>

<body class="h-100">
@if (session('status'))
            <div class="mb-4 font-medium text-sm text-green-600">
                {{ session('status') }}
            </div>
        @endif
    <div class="authincation h-100">
        <div class="container-fluid h-100">
            <div class="row justify-content-center h-100 align-items-center">
                <div class="col-md-6">
                    <div class="authincation-content">
                        <div class="row no-gutters">
                            <div class="col-xl-12">


                                <div class="auth-form">
                                    <h4 class="text-center mb-4">Entrar</h4>
                                    @if ($errors->any())
                                            <ul class="text-danger">
                                                @foreach ( $errors->all() as $error )
                                                <div class="alert alert-danger alert-dismissible" style="text-align: center;">
                                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                                    <h5 style="text-align: center;"><i class="icon fa fa-warning"></i>Falha na Autenticação.</h5>
                                                         E-mail e/ou palavra-passe incorrectos.
                                                </div>
                                                @endforeach
                                            </ul>
                                        @endif

                                        @error('valor')
                                            <span class="text-danger">
                                                <div class="alert alert-danger alert-dismissible" style="text-align: center;">
                                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                                    <h5 style="text-align: center;"><i class="icon fa fa-warning"></i>Falha na Autenticação.</h5>
                                                         E-mail e/ou palavra-passe incorrectos.
                                                </div>
                                            </span>
                                        @enderror


                                    <form method="POST" action="{{ route('login') }}">
                                    @csrf


                                        <div class="form-group">
                                            <label for="email" value="{{ __('Email') }}" ><strong>Email</strong></label>
                                            <input type="email" id="email" name="email" :value="old('email')" class="form-control" >
                                        </div>
                                        <div class="form-group">
                                            <label for="password" value="{{ __('Password') }}"><strong>Password</strong></label>
                                            <input type="password" id="password" class="form-control" name="password" required autocomplete="current-password" >
                                        </div>
                                        <div class="form-row d-flex justify-content-between mt-4 mb-2">
                                            <div class="form-group">
                                                <div class="form-check ml-2">
                                                    <input class="form-check-input" type="checkbox" id="remember_me" name="remember">
                                                    <label class="form-check-label" for="basic_checkbox_1">
                                                    <span class="ml-2 text-sm text-gray-600">{{ __('Remember me') }}</span>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                            @if (Route::has('password.request'))
                                                <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('password.request') }}">
                                                    {{ __('Forgot your password?') }}
                                                </a>
                                            @endif
                                            </div>
                                        </div>
                                        <div class="text-center">
                                            <button type="submit" class="btn btn-primary btn-block">
                                            {{ __('Entrar') }}
                                            </button>
                                        </div>
                                    </form>
                                    <div class="new-account mt-3">
                                        <p>Não Quer entrar na app? <a class="text-primary" href="{{ route('login') }}">Página Principal</a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--**********************************
        Scripts
    ***********************************-->
    <!-- Required vendors -->
    <script src="{{ asset('/platform/vendor/global/global.min.js')}}"></script>
    <script src="{{ asset('/platform/js/quixnav-init.js')}}"></script>
    <script src="{{ asset('/platform/js/custom.min.js')}}"></script>

</body>

</html>
